**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for RDD main regs ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************


** Loop over key varaivles
foreach var in lcapex ln_wages  lcapex_8 lturnover {

********* GFC period regressions
use "$data\rdd_$ids.dta", clear
keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2 // only firms in scope
keep if year == 2009 | year == 2010 // years in scope
** base regressions
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2009 
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2009 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2010 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2010 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2010 


esttab using "$savefile\GFC_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2009" "Q4 2009" "Q1 2009" "Q2 2009" "Q3 2009") 

* With coveraitaes as robustness (don't do long lag capex as breaks)
if "`var'" != "lcapex_8" {
**covs
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2009 , covs(q_to_grow y_to *_div )
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2009 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2010 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2010 , covs(q_to_grow y_to *_div)
 *eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2010 , covs(q_to_grow y_to *_div)
}

esttab using "$savefile\GFC_covs_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2009" "Q4 2009" "Q1 2009" "Q2 2009" "Q3 2009") addnote("Quarterly and annual bas tturnver control") 

** Only uninc
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2009 &   sisca==4000
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2009 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2010 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2010 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2010 &   sisca==4000


esttab using "$savefile\GFC_uninc_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2009" "Q4 2009" "Q1 2009" "Q2 2009" "Q3 2009") 

**Only company
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2009 &   company==1
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2009 &   company==1
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2010 &   company==1
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2010 &   company==1
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2010 &   company==1


esttab using "$savefile\GFC_comp_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2009" "Q4 2009" "Q1 2009" "Q2 2009" "Q3 2009") 

********* 2012 policy
use "$data\rdd_$ids.dta", clear
keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2
keep if year == 2012 | year == 2013 | year == 2014
** Base regressions
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2012 
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2012 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2013 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2013 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2013 
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2013 
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2014 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2014 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2014 
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2014 
esttab using "$savefile\2012_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p" "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2012" "Q4 2012" "Q1 2013" "Q2 2013" "Q3 2013" "Q4 2013" "Q1 2014" "Q2 2014" "Q3 2014" "Q4 2014") 
if "`var'" != "lcapex_8" {
**With covariates
eststo clear
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2012 , covs(q_to_grow y_to *_div)
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2012 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2013 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2013 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2013 , covs(q_to_grow y_to *_div)
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2013 , covs(q_to_grow y_to *_div)
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2014 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2014 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2014 , covs(q_to_grow y_to *_div)
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2014 , covs(q_to_grow y_to *_div)
  
 

esttab using "$savefile\2012_covs_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2012" "Q4 2012" "Q1 2013" "Q2 2013" "Q3 2013" "Q4 2013" "Q1 2014" "Q2 2014" "Q3 2014" "Q4 2014") 
}
**Unincorpated only
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2012 &  sisca==4000
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2012 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2013 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2013 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2013 &   sisca==4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2013 &   sisca==4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2014 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2014 &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2014 &   sisca==4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2014 &   sisca==4000


esttab using "$savefile\2012_uninc_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2012" "Q4 2012" "Q1 2013" "Q2 2013" "Q3 2013" "Q4 2013" "Q1 2014" "Q2 2014" "Q3 2014" "Q4 2014") 


**Company only
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2012 &  sisca!=4000
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2012 &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2013 &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2013 &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2013 &   sisca!=4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2013 &   sisca!=4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2014 &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2014 &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2014 &   sisca!=4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2014 &   sisca!=4000


esttab using "$savefile\2012_comp_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2012" "Q4 2012" "Q1 2013" "Q2 2013" "Q3 2013" "Q4 2013" "Q1 2014" "Q2 2014" "Q3 2014" "Q4 2014") 

********* 2015 policy
use "$data\rdd_$ids.dta", clear
keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2
keep if year == 2015 | year == 2016 | year == 2017
** base
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2015 
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2015 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2016 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2016 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2016 
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2016 
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 1 & year==2017 
    eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 2 & year==2017 
 

esttab using "$savefile\2015_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2015" "Q4 2015" "Q1 2016" "Q2 2016" "Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017") 

if "`var'" != "lcapex_8" {
**covs

eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2015  , covs(q_to_grow y_to *_div)
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2015  , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2016 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2016 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2016 , covs(q_to_grow y_to *_div)
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2016 , covs(q_to_grow y_to *_div)
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 1 & year==2017 , covs(q_to_grow y_to *_div)
    eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 2 & year==2017 , covs(q_to_grow y_to *_div)
	

esttab using "$savefile\2016_covs_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2015" "Q4 2015" "Q1 2016" "Q2 2016" "Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017")  
}

**uninc
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2015  &   sisca==4000
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2015  &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2016  &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2016  &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2016  &   sisca==4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2016  &   sisca==4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 1 & year==2017  &   sisca==4000
    eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 2 & year==2017  &   sisca==4000
 
	
esttab using "$savefile\2015_uninc_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2015" "Q4 2015" "Q1 2016" "Q2 2016" "Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017")  


**comp
eststo clear
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2015  &   sisca!=4000
eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2015  &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 1 & year==2016  &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 &  income> $lb2 & quarter== 2 & year==2016  &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2016  &   sisca!=4000
 eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 4 & year==2016  &   sisca!=4000
  eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 1 & year==2017  &   sisca!=4000
    eststo: rdrobust `var' sales2_c if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 2 & year==2017  &   sisca!=4000
 
	
esttab using "$savefile\2015_comp_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2015" "Q4 2015" "Q1 2016" "Q2 2016" "Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017")  


********* 2016 10 m policy 
use "$data\rdd_$ids.dta", clear
keep if  income_l<$ubl10 & income_l>$lb10 & income> $lb10
keep if year == 2017 | year == 2016 
** base
eststo clear
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2016 
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2016 
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 1 & year==2017 
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 2 & year==2017 
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2017 
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2017 


esttab using "$savefile\10m_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017" "Q3 2017" "Q4 2017") 

if "`var'" != "lcapex_8" {
**covs
eststo clear
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2016 , covs(q_to_grow y_to )
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2016 , covs(q_to_grow y_to )
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 1 & year==2017 , covs(q_to_grow y_to )
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 2 & year==2017 , covs(q_to_grow y_to )
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2017 , covs(q_to_grow y_to )
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2017 , covs(q_to_grow y_to )


esttab using "$savefile\10m_covs_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)   mtitles("Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017" "Q3 2017" "Q4 2017") 
}

**uninc
eststo clear
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2016 &   sisca==4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2016 &   sisca==4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 1 & year==2017 &   sisca==4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 2 & year==2017 &   sisca==4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2017 &   sisca==4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2017 &   sisca==4000


esttab using "$savefile\10m_uninc_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017" "Q3 2017" "Q4 2017") 


**comp
eststo clear
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2016 &   sisca!=4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2016 &   sisca!=4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 1 & year==2017 &   sisca!=4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 2 & year==2017 &   sisca!=4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 3 & year==2017 &   sisca!=4000
eststo: rdrobust `var' sales10_c if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 4 & year==2017 &   sisca!=4000


esttab using "$savefile\10m_comp_`ids'_`var'.rtf",  stats(ci_rb N pv_cl pv_rb h_l h_r,  labels("Robust 95 CI" "Obs" "Convetional P" "Robust p"  "Bandwidth lower" "Bandwidth upper")) replace star(* 0.10 ** 0.05 *** 0.01)  mtitles("Q3 2016" "Q4 2016" "Q1 2017" "Q2 2017" "Q3 2017" "Q4 2017") 
}

